/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.BarrelType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    private final String title = I18n.func_135052_a((String)ModBlocks.blockBarrel.func_149739_a(), (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final ITickTimer timer;

    public CompostRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(80, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.blockBarrel));
        this.slot = guiHelper.getSlotDrawable();
        this.timer = guiHelper.createTickTimer(60, BarrelType.values().length - 2, false);
    }

    @NotNull
    public static List<CompostRecipe> findRecipes() {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().entrySet().stream().map(entry -> CompostRecipe.individualize((Item)entry.getKey(), (CompostRecipe)entry.getValue())).collect(Collectors.toList());
    }

    @NotNull
    public ResourceLocation getUid() {
        return CompostRecipe.ID;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Class<? extends CompostRecipe> getRecipeClass() {
        return CompostRecipe.class;
    }

    public void setIngredients(@NotNull CompostRecipe recipe, @NotNull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@NotNull IRecipeLayout layout, @NotNull CompostRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = layout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, false, 62, 0);
        itemStacks.setBackground(0, this.slot);
        itemStacks.setBackground(1, this.slot);
        itemStacks.set(ingredients);
    }

    public void draw(@NotNull CompostRecipe recipe, @NotNull MatrixStack matrixStack, double mouseX, double mouseY) {
        BarrelType type = BarrelType.byMetadata(this.timer.getValue());
        BlockState barrel = (BlockState)((BlockState)ModBlocks.blockBarrel.func_176223_P().func_206870_a((Property)AbstractBlockBarrel.FACING, (Comparable)Direction.SOUTH)).func_206870_a(AbstractBlockBarrel.VARIANT, (Comparable)((Object)type));
        RenderHelper.renderBlock(matrixStack, barrel, 40.0f, 20.0f, 100.0f, -30.0f, 20.0f, 25.0f);
    }
}

